/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.dialog;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import lib.toma.animations.api.event.AnimationEventType;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.ByteFlags;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.dialog.EventCreateDialog;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import lib.toma.animations.engine.screen.animator.widget.ListView;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AddEventDialog
extends DialogScreen {
    private static final ITextComponent NEXT = new TranslationTextComponent("screen.animator.next");
    private ListView<ResourceLocation> typeSelector;
    private TextFieldWidget position;
    private final ByteFlags errorFlags = new ByteFlags(0);
    private final float pos;
    private final EventCreateDialog.ICreator<?> creator;
    private ResourceLocation selectedValue;
    private final Pattern posPattern = Pattern.compile("(1(\\.0)?)|(0(\\.[0-9]+)?)");

    public AddEventDialog(AnimatorScreen screen, float pos, EventCreateDialog.ICreator<?> creator) {
        super((ITextComponent)new TranslationTextComponent("screen.animator.dialog.add_event"), screen);
        this.pos = pos;
        this.creator = creator;
        this.setDimensions(160, 145);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.errorFlags.set(0);
        int btnWidthP = this.dWidth() - 10;
        int btnWidth = (btnWidthP - 5) / 2;
        this.typeSelector = (ListView)this.func_230480_a_(new ListView<ResourceLocation>(this.left() + 5, this.top() + 15, btnWidthP, 75, Registries.EVENTS.keys()));
        this.typeSelector.setResponder(this::selection_change);
        this.position = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 95, btnWidthP, 20, StringTextComponent.field_240750_d_));
        this.position.func_212954_a((Consumer)new SuggestionResponder("Target", this.position, this::invokeTarget_change));
        this.position.func_146180_a(AnimatorScreen.POSITION_FORMAT.format(this.pos));
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 120, btnWidth, 20, CANCEL, this::cancel_clicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btnWidth, this.top() + 120, btnWidth, 20, NEXT, this::confirm_clicked));
        this.updateConfirmButton();
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    private <E extends IAnimationEvent> void confirm_clicked(Button button) {
        AnimationEventType<?> eventType = Registries.EVENTS.getElement(this.selectedValue);
        if (eventType == null) {
            this.showParent();
        }
        this.field_230706_i_.func_147108_a(eventType.createDialog(this, Float.parseFloat(this.position.func_146179_b()), this.creator));
    }

    private void invokeTarget_change(String value) {
        if (this.posPattern.matcher(value).matches()) {
            this.position.func_146193_g(0xE0E0E0);
            this.errorFlags.clear(1);
        } else {
            this.position.func_146193_g(0xE00000);
            this.errorFlags.set(1);
        }
    }

    private void selection_change(ResourceLocation value) {
        this.selectedValue = value;
        if (value != null) {
            this.errorFlags.clear(0);
        } else {
            this.errorFlags.set(0);
        }
        this.updateConfirmButton();
    }

    private void updateConfirmButton() {
        if (this.confirm != null) {
            this.confirm.field_230693_o_ = this.errorFlags.isEmpty();
        }
    }
}

